<?php

    /*
    Nom du script : php_mysql_insertion_ville.php
    Auteur : Christian VIGOUROUX
    Date de création : 13/07/2024
    Date de dernière modification : 13/07/2024
    Objet : Insertion d'un enregistrement dans la table MySQL villes de la BDD MySQL
    */
	
	// Headers
	header('Access-Control-Allow-Origin: *');
	header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
	header('Access-Control-Allow-Headers: Content-Type');
	header('Content-Type: application/json');

	// Paramètres de la connexion
	$nom_serveur = "nom_serveur";
	$nom_utilisateur = "nom_utilisateur";
	$mot_de_passe = "mot_de_passe";
	$base_de_donnees = "base_de_donnees";
	
	// Création de la connexion
	$conn = new mysqli($nom_serveur, $nom_utilisateur, $mot_de_passe, $base_de_donnees);

	// Vérification de la connexion
	if ($conn->connect_error) {
		die(json_encode(['success' => false, 'message' => 'Connection failed: ' . $conn->connect_error]));
	}

	// Récupération des données postées par l'application client (nom de la ville)
	$data = json_decode(file_get_contents('php://input'), true);
	if (json_last_error() !== JSON_ERROR_NONE) {
		die(json_encode(['success' => false, 'message' => 'Invalid JSON data']));
	}
	$nomVille = $data['nomVille'] ?? '';

	// Test du nom de la ville (non vide)
	if (empty($nomVille)) {
		die(json_encode(['success' => false, 'message' => 'Nom de la ville est vide']));
	}

	// Préparation et exécution de la requête SQL
	$stmt = $conn->prepare("INSERT INTO villes (Nom_ville) VALUES (?)");
	$stmt->bind_param("s", $nomVille);

	// Evaluation de l'exécution de la requête SQL
	if ($stmt->execute()) {
		echo json_encode(['success' => true]);
	} else {
		echo json_encode(['success' => false, 'message' => 'Error: ' . $stmt->error]);
	}

	// Libération des ressources
	$stmt->close();
	$conn->close();

?>